# SEARCH FOR MODULES, SUBROUTINES, AND FUNCTIONS
# WRITE A LIBRARY WITH THE RESULTS

from utils import getFilenames

def check4name(ar,line,name,srcfile):
    upline = line.upper()
    if len(upline.split()) > 1 and upline.split()[0] != '!':
        if upline[:6] == name and name == 'MODULE':
            tmp = upline.split()[1]
            if '(' in tmp:
                subname=tmp.split('(')[0]
            else:
                subname=tmp
                ar.append([name,subname,srcfile])
        elif upline.split()[0] == name and name in ['SUBROUTINE','FUNCTION','INTERFACE']:
            if upline.split()[1] != '!':
                tmp = upline.split()[1]
                if '(' in tmp:
                    subname=tmp.split('(')[0]
                else:
                    subname=tmp
                ar.append([name,subname,srcfile])
        elif upline.split()[1] == name and name in ['FUNCTION'] \
            and upline.split()[0] != 'END':
            tmp = upline.split()[2]
            if '(' in tmp:
                subname=tmp.split('(')[0]
            else:
                subname=tmp
            ar.append([name,subname,srcfile])
    return ar

def getmodules(f,srcfile):
#    print 'Opening %s ' % srcfile
    try:
        for line in open(srcfile):
            f = check4name(f,line,'MODULE',    srcfile)
            f = check4name(f,line,'SUBROUTINE',srcfile)
            f = check4name(f,line,'FUNCTION',  srcfile)
            f = check4name(f,line,'INTERFACE',  srcfile)
    except:
        print "cannot open %s" % srcfile
#    for line in open(srcfile):
#        f = check4name(f,line,'MODULE',    srcfile)
#        f = check4name(f,line,'SUBROUTINE',srcfile)
#        f = check4name(f,line,'FUNCTION',  srcfile)
    return f

def writeModFile(ar,filename):
    fn = open(filename, 'w')
    for f in ar:
        if f[0] == 'MODULE':
            fn.write('%-11s%-35s%-20s\n' % (f[0],f[1],f[2]))
    for f in ar:
        if f[0] == 'SUBROUTINE':
            fn.write('%-11s%-35s%-20s\n' % (f[0],f[1],f[2]))
    for f in ar:
        if f[0] == 'FUNCTION':
            fn.write('%-11s%-35s%-20s\n' % (f[0],f[1],f[2]))
    for f in ar:
        if f[0] == 'INTERFACE':
            fn.write('%-11s%-35s%-20s\n' % (f[0],f[1],f[2]))
    fn.close()
    return None

def getAllMods(modname):
    f = [] #= open(modname, 'w')
    for filename in getFilenames('../source'):
        f = getmodules(f,filename)
    writeModFile(f,modname)
    return None

if __name__ == '__main__':
    getAllMods('Modules.txt')
