################################################################
#                    CHARMM SOURCE VIEWER                      #
#                        version 0.0.2                         #
#                    B. Scott Perrin, Jr.                      #
#                     November 18, 2016                        #
################################################################
# USER SETTINGS:
ChmSrcDir ='../source'               # LOCATION OF CHARMM SOURCE
ModuleList='Module.txt'              # FILE TO CONTAIN LIST OF 
css='src2htmlv3.css'                   #     CHARMM MODULES

################################################################
from utils import getFilenames
from src2htmlv3 import src2html
from getmodules import getAllMods
import os
from shutil import copyfile

#getAllMods(ModuleList)

htmldir='html4'
if not os.path.exists(htmldir):
    os.makedirs(htmldir)
copyfile(css, '%s/%s' % (htmldir,css))

for filename in getFilenames(ChmSrcDir):
    newname   = filename.replace('.src','.html')
    newname   = newname.replace(ChmSrcDir,htmldir)
    tmp       = newname.split('/')[:-1]
    directory = tmp[0]
    for t in tmp[1:]:
        directory = '%s/%s' % (directory,t)
    if not os.path.exists(directory):
        os.makedirs(directory)
    src2html(filename,newname,ModuleList)
