#
# To Do:
#    Add secondary collapse for IF statements
#    Populate sidebar with properties called in suroutine
#    Link use command to modules code
#    Clean up 'v3' labels


def topbar(f, name, modfile):
    '''
       The menu bar. For now, keep dropdown div placeholders here. Could move elsehwere in the HTML.
    '''
    f.write('<div id="topbar">\n')
    f.write('  <table class="tb"><tr>\n')
    f.write('  <td class="tb1h">%s/%s</td>\n' % (name.split('/')[-2],name.split('/')[-1]))
    f.write('  <td class="tb1"><div class="dropdown">\n')
    f.write('    <button onclick="myFunction(\'SubDropdown\')" class="dropbtn">Subroutines</button>\n')
    f = SubDropDown(f, '%s/%s' % (name.split('/')[-2],name.split('/')[-1]), modfile)
    f.write('  </div></td>\n')
    f.write('  <td class="tb1"><a href="#" class="tb1 closeall">Collapse All</a></td>\n')
    f.write('  <td class="tb1"><a href="#" class="tb1 openall">Expand All</a></td>\n')
    f.write('  <td class="tb1"><div class="dropdown">\n')
    f.write('    <button onclick="myFunction(\'PreDropdown\')" class="dropbtn">Preprocess</button>\n')
    f.write('    <div id="PreDropdown" class="dropdown-content">\n')
    f.write('      <a href="#">This will be</a>\n')
    f.write('      <a href="#">a list of</a>\n')
    f.write('      <a href="#">preprocessor options</a>\n')
    f.write('    </div>\n')
    f.write('  </div></td>\n')
    f.write('  <td class="tb1"><a href="../" class="tb1">Folder List</a></td>\n')
    f.write('  </tr></table>\n')
    f.write('</div>\n')
    return f

def SubDropDown(f, name, modfile):
    f.write('    <div id="SubDropdown" class="dropdown-content">\n')
    for line in open(modfile):
        if name in line and line.split()[0] == 'SUBROUTINE':
            f.write('      <a href="#%s">%s</a>\n' % (line.split()[1],line.split()[1]))
    f.write('    </div>\n')
    return f

def sidebar(f, name, subroutines, modules, variables):
    '''
       A placeholder for the sidebar. This may take some work.
    '''
    version='0.0.3'
    f.write('<div class="sidebar" style="display: none;">\n')
    f.write('  <table class="sb">\n')
    f.write('  <tr><td class="sb0h">SUBROUTINE<br>%s</td></tr>\n' % name)
    f.write('  <tr><td class="sb1h"> SUBROUTINES CALLED</td></tr>\n')
    for subroutine in subroutines:
        f.write('  <tr><td class="sb1">%s</td></tr>\n' % subroutine)
    f.write('  <tr><td class="sb2h"> MODULES USED</td></tr>\n')
    for module in modules:
        f.write('  <tr><td class="sb1">%s</td></tr>\n' % module)
    f.write('  <tr><td class="sb3h"> VARIABLES</td></tr>\n')
    for variable in variables:
        f.write('  <tr><td class="sb3">%s</td></tr>\n' % variable)
    f.write('  </table>\n')
    f.write('  <span id="title">CHARMM Source Viewer<br>version %s</span>\n' % version)
    f.write('</div>\n')
    return f

def header(f):
    f.write('<!DOCTYPE html>\n')
    f.write('<html>\n')
    f.write('<head>\n')
    f.write('  <meta name="viewport" content="width=device-width, initial-scale=1">\n')
    f.write('  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">\n')
    f.write('  <link rel="stylesheet" href="../src2html.css">\n')
    f.write('  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>\n')
    f.write('  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>\n')
    f.write('</head>\n')
    f.write('<body>\n')
    f.write('<br>\n')
    f.write('<br>\n')
    return f

def footer(f,version):
    f.write("<script>\n")
    f.write("$('.closeall').click(function(){\n")
    f.write("  $('.panel-collapse.in')\n")
    f.write("    .collapse('hide');\n")
    f.write("});\n")
    f.write("$('.openall').click(function(){\n")
    f.write("  $('.panel-collapse:not(\".in\")')\n")
    f.write("    .collapse('show');\n")
    f.write("});\n")
    f.write("</script>\n")
    f.write("<script>\n")
    f.write("/* When the user clicks on the button,\n") 
    f.write("toggle between hiding and showing the dropdown content */\n")
    f.write("function myFunction(Id) {\n")
    f.write("    document.getElementById(Id).classList.toggle(\"show\");\n")
    f.write("}\n")
    f.write("\n")
    f.write("// Close the dropdown menu if the user clicks outside of it\n")
    f.write("window.onclick = function(event) {\n")
    f.write("  if (!event.target.matches('.dropbtn')) {\n")
    f.write("\n")
    f.write("    var dropdowns = document.getElementsByClassName(\"dropdown-content\");\n")
    f.write("    var i;\n")
    f.write("    for (i = 0; i < dropdowns.length; i++) {\n")
    f.write("      var openDropdown = dropdowns[i];\n")
    f.write("      if (openDropdown.classList.contains('show')) {\n")
    f.write("        openDropdown.classList.remove('show');\n")
    f.write("      }\n")
    f.write("    }\n")
    f.write("  }\n")
    f.write("}\n")
    f.write("</script>\n")
    f.write("<div id='date'>\n")
    f.write('  <span id="title">CHARMM Source Viewer<br>version %s</span>\n' % version)
    f.write("</div>\n")
    f.write("<script>\n")
    f.write("$(window).on('load',function () {\n")
    f.write("    $(window).on(\"scroll resize\", function () {\n")
    f.write("        var pos = $('#date').offset();\n")
    f.write("        $('.panel-default').each(function () {\n")
    f.write("            if (pos.top >= $(this).offset().top) { //&& pos.top <= $(this).next().offset().top) {\n")
    f.write("                $('#date').html($(this).find('.sidebar').html());\n")
    f.write("                return; //break the loop\n")
    f.write("            }\n")
    f.write("        });\n")
    f.write("    });\n")
    f.write("    $(document).ready(function () {\n")
    f.write("        $(window).trigger('scroll'); // init the value\n")
    f.write("    });\n")
    f.write("})\n")
    f.write("</script>\n")
    f.write('</body>\n')
    f.write('</html>\n')
    return f

def recordRoutine(line, f, ID, ModuleList, depth):
    if line.upper().startswith('  SUBROUTINE') or line.upper().startswith('SUBROUTINE'):
        ModName=line.split()[1].split('(')[0]
        if depth == 1:
            f.write('    <div class="panel panel-default">\n')
            # Add sidebar stuff
            f = sidebar(f, ModName, [], [], [])
        else:
            f.write('    <div class="panel panel-info">\n')
        f.write('      <div class="panel-heading">\n')
        f.write('        <h4 class="panel-title">\n')
        f.write('          <a data-toggle="collapse" data-parent="#accordion" id="%s" href="#collapse%s">%s</a>\n' % (ModName,ID,line))
        f.write('        </h4>\n')
        f.write('      </div>\n')
        f.write('      <div id="collapse%s" class="panel-collapse collapse in">\n' % ID)
        f.write('        <div class="panel-body">\n')
    elif line.upper().startswith('  END SUBROUTINE') or line.upper().startswith('END SUBROUTINE'):
        f.write('        </div>\n')
        f.write('      </div>\n')
        f.write('    </div>\n')
    else:
        f = NotRoutine(line, f, ModuleList)
    return f 

def NotRoutine(line, f, ModuleList):
    if line.strip().startswith('!'):
        f.write('<span class="comment">%s</span><br>\n' % line.replace("\n",""))
    elif line.strip().lower().startswith('real') or \
         line.strip().lower().startswith('logical') or \
         line.strip().lower().startswith('integer'):
        checkline(line,f,"setvar")
    elif line.strip().lower().startswith('use'):
        if line.split()[0].lower() == 'use': 
            line = addlink(line,'use',ModuleList)
            checkline(line,f,"use")
    elif line.strip().lower().startswith('call'):
        if line.split()[0].lower() == 'call':
            line = addlink(line,'call',ModuleList)
            checkline(line,f,"call")
    else:
        checkline(line,f,"undecorated")
        #f.write('<span class="undecorated">%s</span><br>\n' % line.replace("\n",""))
    return f

def checkline(line, f, classname):
    if '!' in line:
        i = line.index('!')
        f.write('<span class="%s">%s</span>\n' % (classname, line[:i]))
        f.write('<span class="comment">%s</span><br>\n' % line[i:].replace("\n",""))
    else:
        f.write('<span class="%s">%s</span><br>\n' % (classname, line.replace("\n","")))
    return f

def addlink(line,modtype,ModuleList):
    links = openlinks(linkfile=ModuleList)
    if modtype == 'use':
        for link in links:
            if len(line.split()) < 2:
                print line
            elif link[1] == line.split()[1].upper().split(',')[0] and link[0] == 'MODULE':
                if ',' in line.split()[1]:
                    oldtext=line.split()[1]
                    oldtext=oldtext.split(',')[0]
                    newtext="<a href='%s'>%s</a>" % (link[2],oldtext)
                    line = line.replace(oldtext,newtext,1)
                else:
                    newtext="<a href='%s'>%s</a>" % (link[2],line.split()[1])
                    line = line.replace(line.split()[1],newtext)
    if modtype == 'call':
        for link in links:
            if len(line.split()) < 2:
                print line
            elif link[1] == line.split()[1].upper().split('(')[0]:
                if '(' in line.split()[1]:
                    oldtext=line.split()[1]
                    oldtext=oldtext.split('(')[0]
                    newtext="<a href='%s#%s'>%s</a>" % (link[2],oldtext,oldtext)
                    line = line.replace(oldtext,newtext,1)
                else:
                    newtext="<a href='%s#%s'>%s</a>" % (link[2],line.split()[1],line.split()[1])
                    line = line.replace(line.split()[1],newtext)
    return line

def cleanline(line):
    line = line.replace("\n","")
#   line = line.replace(" ","&nbsp;")
    line = line.replace("&","&amp;")
    line = line.replace("<","&lt;")
    line = line.replace(">","&gt;")
    line = line.replace('"',"&quot;")
    line = line.replace("'","&apos;")
    return line

def src2html(srcname,htmlname,ModuleList):
    version='0.0.3'
    f = open(htmlname, 'w')
    f = header(f)
    f = topbar(f, srcname[10:],ModuleList)
#    f = sidebar(f, 'NAME', [], [], [])
    f.write('<div style="margin-left:0px" class="container">\n')
    f.write('  <div class="panel-group" id="accordion">')

    inRoutine = False
    ID = 0
    depth = 0
    for line in open(srcname):
        cline = cleanline(line)
        if line.upper().startswith('SUBROUTINE') or line.upper().startswith('  SUBROUTINE'):
            if inRoutine:
                depth = depth + 1
                ID = ID + 1
            else:
                depth = depth + 1
                inRoutine = True
                ID = ID + 1
        if inRoutine:
            if line.upper().startswith('END SUBROUTINE') or line.upper().startswith('  END SUBROUTINE'):
                f = recordRoutine(cline,f,ID, ModuleList, depth)
                inRoutine = False
                depth = depth - 1
            else:
                f = recordRoutine(cline,f,ID,ModuleList, depth)
        else:
            f = NotRoutine(cline, f, ModuleList)
    f.write('</div>')
    f = footer(f, version)

def openlinks(linkfile='Module.txt'):
    data = []
    for line in open(linkfile):
        line = line.replace('.src','.html')
        line = line.replace('source/','')
        data.append(line.split())        
    return data

if __name__ == '__main__':
    name='repdstr_c41b1'
    #name='upimag'
    src2html('src/%s.src' % name,'html/%s.html' % name, 'Module.txt')

